package gov.va.med.mhv.admin.web.util;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;

import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleHistoryDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;

/**
 * This class contains the various sort implementations required by the Manage
 * VA Staff portlet
 * 
 * @author DNS
 *
 */
public class SortUtil {

	public void imposeDefaultSortOrderViewAll(List<EmployeeOrgRoleDTO> existingRoleAssignments) {
		Locale.setDefault(Locale.ENGLISH);

		if (existingRoleAssignments != null) {

			existingRoleAssignments.sort(new Comparator<EmployeeOrgRoleDTO>() {

				@Override
				public int compare(EmployeeOrgRoleDTO o1, EmployeeOrgRoleDTO o2) {
					int result = 0;

					if (o1 != null && o2 != null) {

						// order by active flag
						if (o1.getActive() != null && o2.getActive() != null) {

							result = o2.getActive().compareTo(o1.getActive());

						}

						// then by role (role name)
						if (result == 0 && o1.getRole() != null && o2.getRole() != null
								&& o1.getRole().getName() != null && o2.getRole().getName() != null) {

							result = o1.getRole().getName().compareTo(o2.getRole().getName());

						}

						// then by full name
						if (result == 0 && o1.getEmployee() != null && o2.getEmployee() != null
								&& o1.getEmployee().getFullName() != null && o2.getEmployee().getFullName() != null) {

							result = o1.getEmployee().getFullName().toLowerCase(Locale.ENGLISH)
									.compareTo(o2.getEmployee().getFullName().toLowerCase(Locale.ENGLISH));

						}

					}
					return result;
				}
			});
		}
	}

	public void imposeDefaultSortOrderSearch(List<EmployeeSearchResult> employees) {
		Locale.setDefault(Locale.ENGLISH);

		if (employees != null) {

			employees.sort(new Comparator<EmployeeSearchResult>() {

				@Override
				public int compare(EmployeeSearchResult e1, EmployeeSearchResult e2) {
					int result = 0;

					if (e1 != null && e2 != null) {

						// order by last name
						if (e1.getLastName() != null && e2.getLastName() != null) {

							result = e1.getLastName().toLowerCase(Locale.ENGLISH).compareTo(e2.getLastName().toLowerCase(Locale.ENGLISH));

						}

						// then by first name
						if (result == 0 && e1.getFirstName() != null && e2.getFirstName() != null) {

							result = e1.getFirstName().toLowerCase(Locale.ENGLISH).compareTo(e2.getFirstName().toLowerCase(Locale.ENGLISH));

						}

						// then by VANetworkID (username)
						if (result == 0 && e1.getUserName() != null && e2.getUserName() != null) {

							result = e1.getUserName().toLowerCase(Locale.ENGLISH).compareTo(e2.getUserName().toLowerCase(Locale.ENGLISH));

						}

					}
					return result;
				}
			});
		}
	}

	public void imposeDefaultSortOrderManageStaffMember(List<EmployeeOrgRoleDTO> employeesCurrentRoles) {
		Locale.setDefault(Locale.ENGLISH);

		if (employeesCurrentRoles != null) {

			employeesCurrentRoles.sort(new Comparator<EmployeeOrgRoleDTO>() {

				@Override
				public int compare(EmployeeOrgRoleDTO o1, EmployeeOrgRoleDTO o2) {
					int result = 0;

					if (o1 != null && o2 != null) {

						// order by active flag
						if (o1.getActive() != null && o2.getActive() != null) {

							result = o2.getActive().compareTo(o1.getActive());

						}

						// then by role
						if (result == 0 && o1.getRole() != null && o2.getRole() != null
								&& o1.getRole().getName() != null && o2.getRole().getName() != null) {

							result = o1.getRole().getName().compareTo(o2.getRole().getName());

						}

					}
					return result;
				}
			});
		}

	}

	public void imposeDefaultSortOrderRoleHistory(List<EmployeeOrgRoleHistoryDTO> employeesHistoricalRoles) {
		Locale.setDefault(Locale.ENGLISH);

		if (employeesHistoricalRoles != null) {
			employeesHistoricalRoles.sort(new Comparator<EmployeeOrgRoleHistoryDTO>() {

				@Override
				public int compare(EmployeeOrgRoleHistoryDTO o1, EmployeeOrgRoleHistoryDTO o2) {
					int result = 0;

					if (o1 != null && o2 != null) {

						// order by date
						if (o1.getModificationDate() != null && o2.getModificationDate() != null) {

							result = o2.getModificationDate().compareTo(o1.getModificationDate());

						}

						// then by Level (tyep of organization)
						if (result == 0 && o1.getEmployeeOrgRoleDTO() != null && o2.getEmployeeOrgRoleDTO() != null
								&& o1.getEmployeeOrgRoleDTO().getOrganization() != null
								&& o2.getEmployeeOrgRoleDTO().getOrganization() != null
								&& o1.getEmployeeOrgRoleDTO().getOrganization().getTypeOfOrganization() != null
								&& o2.getEmployeeOrgRoleDTO().getOrganization().getTypeOfOrganization() != null) {

							String type1 = o1.getEmployeeOrgRoleDTO().getOrganization().getTypeOfOrganization();
							String type2 = o2.getEmployeeOrgRoleDTO().getOrganization().getTypeOfOrganization();
							result = type1.compareTo(type2);

						}

						// then by Role (role name)
						if (result == 0 && o1.getEmployeeOrgRoleDTO() != null && o2.getEmployeeOrgRoleDTO() != null
								&& o1.getEmployeeOrgRoleDTO().getRole() != null
								&& o2.getEmployeeOrgRoleDTO().getRole() != null
								&& o1.getEmployeeOrgRoleDTO().getRole().getName() != null
								&& o2.getEmployeeOrgRoleDTO().getRole().getName() != null) {

							String name1 = o1.getEmployeeOrgRoleDTO().getRole().getName();
							String name2 = o2.getEmployeeOrgRoleDTO().getRole().getName();
							result = name1.compareTo(name2);

						}

					}
					return result;
				}
			});
		}

	}

}
